/* Paco Mouse -- F. Cañada 2022-2025 --  https://usuaris.tinet.cat/fmco/
   
   Fixed width font for symbols

   This font is very useful when using overstrike as all characters & numbers
   are all the same width.

   This font also contains a few special characters that are nice for certain applications
   like clocks, signed values or decimal point values.

   The rendering code normally inserts a pad pixel so this size allows the font to fit
   perfectly on 32 and 64 tall glcd displays.

   Font has also been squeezed to 15 pixels wide for better alignment on 128 & 192 pixel displays.

   This file is part of the Paco Mouse project

*/

#ifndef SYM_PROPORTIONAL_H
#define SYM_PROPORTIONAL_H

/*
  The font data are defined as

  struct _FONT_ {
        uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
        uint8_t    font_Width_in_Pixel_for_fixed_drawing;
        uint8_t    font_Height_in_Pixel_for_all_characters;
        uint8_t    font_First_Char;
        uint8_t    font_Char_Count;

        uint8_t    font_Char_Widths[font_Last_Char - font_First_Char + 1];
                     // for each character the separate width in pixels,
                     // characters < 128 have an implicit virtual right empty row

        uint8_t    font_data[];
                     // bit field of all characters
*/

GLCDFONTDECL(Sym_44x64) = // LCD Assistant (vertical)
{
  0x00, 0x00, // size of zero indicates fixed width font
  44,         // width
  64,         // height
  '+',        // first char
  1,          // char count

  // char '+'
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0xE0, 0xF0, 0xF8, 0xF8, 0xFC,
  0xFC, 0xFE, 0xFE, 0xFF, 0xFF, 0x7F, 0x1F, 0x1F, 0x1F, 0x3F, 0x3F, 0x3F, 0x3E, 0x3C, 0x7C, 0xF8,
  0xF0, 0xC0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xE0, 0xFC, 0xFE, 0xFF, 0x7F, 0x3F, 0x1F, 0x07, 0x07, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x0F,
  0x3F, 0xFF, 0xFE, 0xF8, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF,
  0xF9, 0xF8, 0xF8, 0xF0, 0xF0, 0xF0, 0xE0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xC0, 0xC0, 0xC0, 0x80, 0x00, 0x01, 0x3F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x3E,
  0x3F, 0x3F, 0x0D, 0xFC, 0xF8, 0x30, 0x30, 0x30, 0x70, 0xF8, 0xF8, 0x1C, 0x0D, 0x0F, 0x7F, 0x7F,
  0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFF, 0xEF, 0x0B, 0x1B, 0xF8, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x01, 0xC3, 0xFF, 0xFF, 0x07, 0x0F, 0x0E, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0xFC, 0xFC, 0xCF, 0x87,
  0x03, 0x00, 0x00, 0x00, 0x80, 0x83, 0x0F, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x10, 0x30, 0x30, 0x30,
  0x10, 0x30, 0x38, 0x18, 0x18, 0x1F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0xFF, 0xFF, 0xFF,
  0xF0, 0x80, 0x80, 0xE0, 0xF8, 0xFC, 0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFC, 0xFC, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x80, 0xF0, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x01, 0x07, 0x0F, 0x3F, 0x7F, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE,
  0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFC, 0xFC, 0xFC, 0xFE, 0xFF, 0xFF, 0x3F, 0x1F,
  0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x0F, 0x1F, 0x3F, 0x3F,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x7F,
  0x7F, 0x3F, 0x1F, 0x1F, 0x1F, 0x0F, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GLCDFONTDECL(Sym_Bars) =
{
  0x00, 0xA8, // size
  16,         // width
  8,          // height
  '+',        // first char
  26,         // char count

  // char widths
  0x08, 0x05, 0x08, 0x08, 0x10, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x07, 0x07, 0x0F, 0x02, 0x03,

  // font data
  0x3C, 0x42, 0x99, 0xBD, 0xBD, 0x99, 0x42, 0x3C,                                                     // Of           +
  0x00, 0x00, 0x00, 0x00, 0x00,                                                                       // empty5       ,
  0x3C, 0x42, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3C,                                                     // Oe           -
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,                                                     // empty8       .
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     // empty16      /
  0x36, 0x41, 0x41, 0x41, 0x36,                                                                       // 0
  0x00, 0x00, 0x04, 0x02, 0x77,                                                                       // 1
  0x30, 0x49, 0x49, 0x49, 0x06,                                                                       // 2
  0x00, 0x49, 0x49, 0x49, 0x36,                                                                       // 3
  0x07, 0x08, 0x08, 0x08, 0x77,                                                                       // 4
  0x06, 0x49, 0x49, 0x49, 0x30,                                                                       // 5
  0x36, 0x49, 0x49, 0x49, 0x30,                                                                       // 6
  0x00, 0x01, 0x01, 0x01, 0x76,                                                                       // 7
  0x36, 0x49, 0x49, 0x49, 0x36,                                                                       // 8
  0x06, 0x49, 0x49, 0x49, 0x36,                                                                       // 9
  0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55,           // checked      :
  0x80, 0xC0, 0xA0, 0x90, 0x88, 0x84, 0x82, 0xAD, 0x82, 0x84, 0x88, 0x90, 0xA0, 0xC0, 0x80,           // danger       ;
  0x24, 0x7E, 0x24, 0x24, 0x7E, 0x24, 0x24, 0x7E, 0x24, 0x24, 0x7E, 0x24, 0x24, 0x7E, 0x24,           // track        <
  0xE0, 0xF0, 0xF6, 0xEF, 0xEF, 0xF6, 0xF0, 0xE0, 0x00, 0x42, 0x28, 0x1A, 0x38, 0x04, 0x50,           // other        =
  0xFF, 0x81, 0xBD, 0xBD, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF, 0x3C,           // low batt     >
  0xFF, 0xFF, 0x00, 0xFC, 0xFC, 0x00, 0xF0, 0xF0, 0x00, 0xDB, 0xDF, 0x0E, 0x1F, 0x1B, 0x00,           // no wifi      ?
  0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,                                                           // snake        @
  0x00, 0x18, 0x24, 0x42, 0x42, 0x24, 0x18,                                                           // food         A
  0xc4, 0xfe, 0xc5, 0xf5, 0xf5, 0xc5, 0xfe, 0xc4, 0x00, 0x42, 0x28, 0x1a, 0x38, 0x04, 0x50,           // shuttle      B
  0x00, 0x00,                                                                                         // empty2       C
  0x60, 0x1C, 0x03,                                                                                   // slash        D
};


#endif
