/* Paco Mouse -- F. Cañada 2022-2025 --  https://usuaris.tinet.cat/fmco/

   Fixed width font for symbols

   This font is very useful when using overstrike as all characters & numbers
   are all the same width.

   This font also contains a few special characters that are nice for certain applications
   like clocks, signed values or decimal point values.

   The rendering code normally inserts a pad pixel so this size allows the font to fit
   perfectly on 32 and 64 tall glcd displays.

   Font has also been squeezed to 15 pixels wide for better alignment on 128 & 192 pixel displays.

   This file is part of the Paco Mouse project

*/

#ifndef SYM_16x16_H
#define SYM_16x16_H

GLCDFONTDECL(Sym_16x16) = // LCD Assistant (vertical)
{
  0x0, 0x0,  // size of zero indicates fixed width font
  15,   // width  (will be 16 with pad pixel on right)
  15,   // height (will be 16 with pad pixel on bottom)
  '+',  // first char
  19,   // char count

  // char '+'
  0xE0, 0x18, 0xC4, 0xF2, 0xFA, 0xF9, 0xFD, 0xFD, 0xFD, 0xF9, 0xFA, 0xF2, 0xC4, 0x18, 0xE0, // Of
  0x03, 0x0C, 0x11, 0x27, 0x2F, 0x4F, 0x5F, 0x5F, 0x5F, 0x4F, 0x2F, 0x27, 0x11, 0x0C, 0x03,
  // char ','
  0x00, 0x00, 0x00, 0xC0, 0x20, 0xD0, 0xE8, 0xE8, 0xE8, 0xD0, 0x20, 0xC0, 0x00, 0x00, 0x00, //of
  0x00, 0x00, 0x00, 0x01, 0x02, 0x05, 0x0B, 0x0B, 0x0B, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00,
  // char '-'
  0xE0, 0x18, 0x04, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x04, 0x18, 0xE0, // Ov
  0x03, 0x0C, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x10, 0x0C, 0x03,
  // char '.'
  0x00, 0x00, 0x00, 0xC0, 0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0xC0, 0x00, 0x00, 0x00, // ov
  0x00, 0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x08, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00,
  // char '/'
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // space
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  // char '0'
  0x00, 0x00, 0x00, 0xFC, 0xE8, 0xE8, 0xD0, 0xD0, 0xA0, 0xA0, 0x40, 0xC0, 0x80, 0x00, 0x00, // arrow ->
  0x00, 0x00, 0x00, 0x1F, 0x0B, 0x0B, 0x05, 0x05, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00,
  //char '1'
  0x00, 0x00, 0xFC, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFC, 0x00, 0x00, // check empty
  0x00, 0x00, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x00, 0x00,
  //char '2'
  0x00, 0x00, 0xFC, 0xC4, 0xC4, 0x84, 0x04, 0x84, 0x84, 0xC4, 0x64, 0x34, 0xFC, 0x00, 0x00, // check mark
  0x00, 0x00, 0x1F, 0x10, 0x11, 0x13, 0x17, 0x13, 0x11, 0x10, 0x10, 0x10, 0x1F, 0x00, 0x00,
  //char '3'
  0x00, 0x00, 0x80, 0xC0, 0x40, 0xA0, 0xA0, 0xD0, 0xD0, 0xE8, 0xE8, 0xFC, 0x00, 0x00, 0x00, // <- arrow
  0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x05, 0x05, 0x0B, 0x0B, 0x1F, 0x00, 0x00, 0x00,
  //char '4'
  0x00, 0x20, 0xF0, 0x28, 0x24, 0x24, 0xA4, 0xA4, 0x24, 0x24, 0x24, 0x28, 0xF0, 0x20, 0x00, // station
  0x00, 0x30, 0x3F, 0x30, 0x30, 0x3F, 0x3F, 0x3F, 0x3F, 0x30, 0x31, 0x30, 0x3F, 0x30, 0x00,
  //char '5'
  0xE0, 0xC0, 0xF0, 0x30, 0x18, 0x1C, 0x0C, 0x0C, 0x0C, 0x1C, 0x18, 0x30, 0xF0, 0xC0, 0xE0, // giro 180
  0x01, 0x01, 0x01, 0x7D, 0x00, 0x7C, 0x54, 0x7C, 0x00, 0x7C, 0x44, 0x7D, 0x01, 0x01, 0x01,
  //char '6'
  0x00, 0x00, 0xc0, 0xf0, 0xf8, 0xf8, 0xfc, 0xfc, 0xfc, 0xf8, 0xf8, 0xf0, 0xc0, 0x00, 0x00, // cursor
  0x00, 0x00, 0x01, 0x07, 0x0f, 0x0f, 0x1f, 0x1f, 0x1f, 0x0f, 0x0f, 0x07, 0x01, 0x00, 0x00,
  //char '7'
  0x03, 0x07, 0xce, 0xfc, 0xf8, 0xf8, 0xfc, 0xfc, 0xfc, 0xf8, 0xf8, 0xfc, 0xce, 0x07, 0x03, // cross-cursor
  0x60, 0x70, 0x39, 0x1f, 0x0f, 0x0f, 0x1f, 0x1f, 0x1f, 0x0f, 0x0f, 0x1f, 0x39, 0x70, 0x60,
  //char '8'
  0x00, 0x00, 0x50, 0x61, 0x63, 0x6f, 0x4d, 0x6f, 0x75, 0x73, 0x65, 0x20, 0x50, 0x61, 0x63, // circle-cursor
  0x6f, 0x20, 0x43, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x20, 0x32, 0x30, 0x32, 0x33, 0x00, 0x00,
  //char '9'
  0x03, 0x07, 0x0e, 0x1c, 0x38, 0x70, 0xe0, 0xc0, 0xe0, 0x70, 0x38, 0x1c, 0x0e, 0x07, 0x03, // cross
  0x60, 0x70, 0x38, 0x1c, 0x0e, 0x07, 0x03, 0x01, 0x03, 0x07, 0x0e, 0x1c, 0x38, 0x70, 0x60,
  //char ':'
  0xe0, 0x98, 0x14, 0x02, 0x06, 0x01, 0x01, 0xfb, 0x01, 0x01, 0x06, 0x02, 0x14, 0x98, 0xe0, // clock
  0x03, 0x0c, 0x14, 0x20, 0x30, 0x40, 0x40, 0x60, 0x41, 0x42, 0x30, 0x20, 0x14, 0x0c, 0x03,
  //char ';'
  0x1e, 0x7f, 0xff, 0xff, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // phone
  0x00, 0x00, 0x01, 0x03, 0x07, 0x0f, 0x1e, 0x1c, 0x3c, 0x3e, 0x7e, 0x7e, 0x7e, 0x7e, 0x3c,
  //char '<'
  0x00, 0x00, 0xc0, 0x20, 0x90, 0x48, 0x28, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, // phone pick
  0x3c, 0x43, 0x40, 0x40, 0x43, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  //char '='
  0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x00, 0x00, 0x00, // phone hang
  0x1c, 0x22, 0x21, 0x20, 0x1c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1c, 0x20, 0x21, 0x22, 0x1c,


};




#ifdef USE_AUTOMATION

GLCDFONTDECL(Auto_16x16) = // LCD Assistant (vertical)  Automation icons
{
  0x0, 0x0,  // size of zero indicates fixed width font
  15,   // width  (will be 16 with pad pixel on right)
  15,   // height (will be 16 with pad pixel on bottom)
  'A',  // first char
  23,   // char count


  //char 'A'
  0xff, 0x01, 0xc1, 0x3b, 0x0a, 0x4a, 0x0a, 0x0a, 0x0a, 0x4a, 0x0a, 0x0a, 0x0e, 0xc8, 0x38, // disk empty
  0x0f, 0x0e, 0x09, 0x08, 0x08, 0x0a, 0x09, 0x09, 0x09, 0x0a, 0x08, 0x08, 0x0e, 0x01, 0x00,
  //char 'B'
  0xfc, 0x02, 0x01, 0x01, 0xf9, 0xf9, 0xf1, 0xf1, 0xe1, 0xe1, 0xc1, 0xc1, 0x81, 0x02, 0xfc, // play
  0x1f, 0x20, 0x40, 0x40, 0x4f, 0x4f, 0x47, 0x47, 0x43, 0x43, 0x41, 0x41, 0x40, 0x20, 0x1f,
  //char 'C'
  0xfc, 0x02, 0x01, 0x01, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0x01, 0x01, 0x02, 0xfc, // stop
  0x1f, 0x20, 0x40, 0x40, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x40, 0x40, 0x20, 0x1f,
  //char 'D'
  0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xfe, 0xfe, 0xfc, 0xc0, 0xc0, 0xc0, 0xc0, 0x80, 0x00, // add
  0x01, 0x03, 0x03, 0x03, 0x03, 0x3f, 0x7f, 0x7f, 0x3f, 0x03, 0x03, 0x03, 0x03, 0x01, 0x00,
  //char 'E'
  0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x14, 0xaa, 0x55, 0x2a, 0x14, 0x08, // edit
  0x78, 0x74, 0x62, 0x41, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  //char 'F'
  0x00, 0x00, 0x0c, 0xfc, 0x0c, 0xec, 0x0e, 0xee, 0x0e, 0xec, 0x0c, 0xfc, 0x0c, 0x00, 0x00, // delete
  0x00, 0x00, 0x00, 0x3f, 0x40, 0x5f, 0x40, 0x5f, 0x40, 0x5f, 0x40, 0x3f, 0x00, 0x00, 0x00,
  //char 'G'
  0xe0, 0xf8, 0xfc, 0xfe, 0xde, 0x8f, 0x1f, 0x3f, 0x1f, 0x8f, 0xde, 0xfe, 0xfc, 0xf8, 0xe0, // cancel
  0x03, 0x0f, 0x1f, 0x3f, 0x3d, 0x78, 0x7c, 0x7e, 0x7c, 0x78, 0x3d, 0x3f, 0x1f, 0x0f, 0x03,
  //char 'H'
  0xff, 0x01, 0xc1, 0x3b, 0x0a, 0x4a, 0xca, 0xff, 0xff, 0xff, 0xca, 0x4a, 0x0e, 0xc8, 0x38, // save
  0x0f, 0x0e, 0x09, 0x08, 0x08, 0x08, 0x08, 0x09, 0x0b, 0x09, 0x08, 0x08, 0x0e, 0x01, 0x00,
#if (TURNOUT_ICON == ONLY_TURN)
  //char 'I'
  0x00, 0x00, 0x00, 0x00, 0xff, 0x81, 0xc1, 0xe1, 0xff, 0xf8, 0xfc, 0x7e, 0x3e, 0x1c, 0x08, // red
  0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  //char 'J'
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x08, 0x84, 0x42, 0x22, 0x14, 0x08, // green
  0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
#endif
#if (TURNOUT_ICON == TURN_SIGNAL)
  //char 'I'
  0xff, 0x81, 0xc1, 0xff, 0xf0, 0xf8, 0x7c, 0x3e, 0x1e, 0xec, 0x30, 0x10, 0x10, 0x30, 0xe0,  // red
  0x7f, 0x7f, 0x7f, 0x7f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x67, 0x5a, 0x5a, 0x67, 0x3f,
  //char 'J'
  0xff, 0xff, 0xff, 0xff, 0x10, 0x88, 0x44, 0x22, 0x12, 0xec, 0x30, 0xd0, 0xd0, 0x30, 0xe0, // green
  0x7f, 0x7f, 0x7f, 0x7f, 0x01, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x67, 0x42, 0x42, 0x67, 0x3f,
#endif
#if (TURNOUT_ICON == BUTTON_IB)
  //char 'I'
  0x00, 0x00, 0x3e, 0x41, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x41, 0x3e, 0x00, 0x00, // red
  0x00, 0x00, 0x3e, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x3e, 0x00, 0x00,
  //char 'J'
  0x00, 0x00, 0x3e, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x3e, 0x00, 0x00, // green
  0x00, 0x00, 0x3e, 0x41, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x5d, 0x41, 0x3e, 0x00, 0x00,
#endif
  //char 'K'
  0xe0, 0x18, 0x04, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x04, 0x18, 0xe0, // free
  0x03, 0x0c, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x10, 0x0c, 0x03,
  //char 'L'
  0xe0, 0x18, 0xe4, 0xf2, 0xfa, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfa, 0xf2, 0xe4, 0x18, 0xe0, // occupied
  0x03, 0x0c, 0x13, 0x27, 0x2f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x2f, 0x27, 0x13, 0x0c, 0x03,
  //char 'M'
  0x00, 0xe6, 0xfe, 0xfe, 0xe6, 0xe0, 0xe0, 0xf0, 0xe0, 0xe4, 0xfc, 0x84, 0x84, 0xc4, 0xfc, // loco
  0x0c, 0x0f, 0x0f, 0x1f, 0x3f, 0x3f, 0x1f, 0x0f, 0x0f, 0x1f, 0x3f, 0x3f, 0x1f, 0x0f, 0x0f,
  //char 'N'
  0x00, 0x01, 0x00, 0x00, 0x81, 0x80, 0xc0, 0xc2, 0x00, 0x04, 0x00, 0x10, 0x40, 0x00, 0x00, // speed
  0x20, 0x10, 0x08, 0x05, 0x03, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00,
  //char 'O'
  0xff, 0xff, 0x1b, 0x1b, 0x83, 0x40, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x40, 0x80, // foff
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x20, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x10, 0x0f,
  //char 'P'
  0xff, 0xff, 0x1b, 0x1b, 0x83, 0x40, 0x20, 0x90, 0xd0, 0xd0, 0xd0, 0x90, 0x20, 0x40, 0x80, // fon
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x10, 0x27, 0x4f, 0x5f, 0x5f, 0x5f, 0x4f, 0x27, 0x10, 0x0f,
  //char 'Q'
  0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0x00, 0xaa, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, // rev
  0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x00, 0x2a, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00,
  //char 'R'
  0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0xaa, 0x00, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, // fwd
  0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x2a, 0x00, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00,
  //char 'S'
  0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0x00, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, // change
  0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x00, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01, 0x00,
  //char 'T'
  0xf0, 0x98, 0x6c, 0xde, 0xef, 0x0f, 0xef, 0x1f, 0xef, 0x1f, 0xff, 0x0e, 0x6c, 0x98, 0xf0, // estop
  0x07, 0x0d, 0x1b, 0x3c, 0x7f, 0x78, 0x7f, 0x7c, 0x7b, 0x7c, 0x7f, 0x38, 0x1f, 0x0f, 0x07,
  //char 'U'
  0x00, 0x01, 0x07, 0x09, 0x11, 0x31, 0xf1, 0xf1, 0xf1, 0x31, 0x11, 0x09, 0x07, 0x01, 0x00, // time
  0x00, 0x40, 0x70, 0x48, 0x64, 0x62, 0x71, 0x7b, 0x71, 0x62, 0x64, 0x48, 0x70, 0x40, 0x00,
  //char 'V'
  0x60, 0x6c, 0xfe, 0xfe, 0x9c, 0x0f, 0x0f, 0x9c, 0xfe, 0xfe, 0x6c, 0x60, 0x00, 0x00, 0x00, // jump
  0x00, 0x03, 0x07, 0x07, 0x03, 0x0f, 0x0f, 0x03, 0x17, 0x17, 0x13, 0x10, 0x7c, 0x38, 0x10,
  //char 'W'
  0x00, 0x08, 0x1c, 0x3e, 0x7f, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x3c, 0xf8, 0xf0, 0x00, 0x00, // loop
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0x1f, 0x0f, 0x00, 0x00,

};

#endif
#endif
