/* Paco Mouse -- F. Cañada 2022-2025 --  https://usuaris.tinet.cat/fmco/
 
   Fixed width font for numbers & symbols

   This font is very useful when using overstrike as all characters & numbers
   are all the same width.

   This font also contains a few special characters that are nice for certain applications
   like clocks, signed values or decimal point values.

   The rendering code normally inserts a pad pixel so this size allows the font to fit
   perfectly on 32 and 64 tall glcd displays.

   Font has also been squeezed to 15 pixels wide for better alignment on 128 & 192 pixel displays.

   This file is part of the Paco Mouse project

*/

#ifndef NUM_15x31_H
#define NUM_15x31_H

GLCDFONTDECL(Num_15x31) = { // LCD Assistant (vertical)
  0x0, 0x0,	// size of zero indicates fixed width font
  15,		// width
  31,		// height
  '+',	// first char (48)
  21,		// char count

#if (TURNOUT_ICON == ONLY_TURN)
  // char '+' -> turnout diverge
  0x00, 0xFE, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x00, 0x80, 0xC0, 0xE0, 0xE0, 0xC0, 0x80, 0x00,
  0x00, 0xFF, 0xE0, 0xF0, 0xF8, 0xFC, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F, 0x1F, 0x0F, 0x07, 0x03,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char ',' -> turnout empty
  0x00, 0xFE, 0x02, 0x02, 0x02, 0x02, 0xFE, 0x00, 0x80, 0x40, 0x20, 0x20, 0x40, 0x80, 0x00,
  0x00, 0xFF, 0x20, 0x10, 0x08, 0x04, 0xFF, 0x01, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x03,
  0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char '-'-> turnout straight
  0x00, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x00, 0x80, 0x40, 0x20, 0x20, 0x40, 0x80, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x03,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#endif
#if (TURNOUT_ICON == TURN_SIGNAL)
  // char '+' -> turnout diverge
  0xff, 0x01, 0x01, 0x81, 0xff, 0xe0, 0xf0, 0xf8, 0xfc, 0xfc, 0x78, 0x30, 0x00, 0x00, 0x00,
  0xff, 0xfe, 0xff, 0xff, 0xff, 0x0f, 0x07, 0x83, 0xc1, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0xff, 0xff, 0x79, 0xb0, 0xb0, 0x79, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1c, 0x1b, 0x77, 0x77, 0x1b, 0x1c, 0x0f,

  // char ',' -> turnout empty
  0xff, 0x01, 0x01, 0x81, 0xff, 0x20, 0x10, 0x08, 0x04, 0x84, 0x48, 0x30, 0x00, 0x00, 0x00,
  0xff, 0x02, 0x01, 0x00, 0xff, 0x08, 0x04, 0x82, 0xc1, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x80,
  0x07, 0x04, 0x04, 0x04, 0x07, 0x00, 0x00, 0xff, 0xff, 0xf9, 0x70, 0x70, 0xf9, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x1c, 0x78, 0x78, 0x1c, 0x1f, 0x0f,

  // char '-'-> turnout straight
  0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x10, 0x08, 0x04, 0x84, 0x48, 0x30, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x08, 0x04, 0x82, 0xc1, 0xc0, 0x40, 0x40, 0xc0, 0xc0, 0x80,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x00, 0x00, 0xff, 0xf9, 0xf6, 0x6f, 0x6f, 0xf6, 0xf9, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x1c, 0x78, 0x78, 0x1c, 0x1f, 0x0f,
#endif
#if (TURNOUT_ICON == BUTTON_IB)
  // char '+' -> turnout diverge
  0xf0, 0x08, 0xe4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xe4, 0x08, 0xf0,
  0x07, 0x08, 0x13, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x13, 0x08, 0x07,
  0xf0, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0xf0,
  0x07, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x07,

  // char ',' -> turnout empty
  0xf0, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0xf0,
  0x07, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x07,
  0xf0, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0xf0,
  0x07, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x07,

  // char '-'-> turnout straight
  0xf0, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0xf0,
  0x07, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x07,
  0xf0, 0x08, 0xe4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xe4, 0x08, 0xf0,
  0x07, 0x08, 0x13, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x13, 0x08, 0x07, 
#endif
  // char '.'
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char '/'
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xff, 0xff, 0x0f,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xff, 0xff, 0x0f, 0x0f, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xf0, 0xf0, 0xff, 0xff, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char '0'
  0xf0, 0xf0, 0xfc, 0xfc, 0x0f, 0x0f, 0x03, 0x03, 0x03, 0xcf, 0xcf, 0xfc, 0xfc, 0xf0, 0xf0,
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xc0, 0xc0, 0x3c, 0x3f, 0x03, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x3c, 0x3c, 0x03, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x03, 0x03, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x03, 0x03, 0x00, 0x00,

  // char '1'
  0x30, 0x30, 0x30, 0x30, 0x3c, 0x3c, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,

  // char '2'
  0xf0, 0xf0, 0xfc, 0xfc, 0x0f, 0x0f, 0x03, 0x03, 0x03, 0x03, 0x0f, 0xff, 0xfc, 0xfc, 0xf0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xf0, 0xff, 0x3f, 0x3f, 0x0f,
  0xc0, 0xc0, 0xf0, 0xf0, 0x3c, 0x3c, 0x0f, 0x0f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0f, 0x0f, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,

  // char '3'
  0xf0, 0xf0, 0xfc, 0xfc, 0x0f, 0x0f, 0x03, 0x03, 0x03, 0x03, 0x0f, 0x1f, 0xfc, 0xfc, 0xf0,
  0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xff, 0xdf, 0x8f,
  0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x03, 0x03, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x03, 0x03, 0x00,

  // char '4'
  0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xff, 0xff, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xfc, 0xfc, 0xff, 0xff, 0x03, 0x03, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xc0, 0xc0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00,

  // char '5'
  0xff, 0xff, 0xff, 0xff, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
  0x0f, 0x0f, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0xfc, 0xf0, 0xf0, 0xc0,
  0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x03, 0x03, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x03, 0x03, 0x00,

  // char '6'
  0x00, 0x00, 0xc0, 0xc0, 0xf0, 0xf0, 0x3c, 0x3c, 0x0f, 0x0f, 0x03, 0x03, 0x03, 0x03, 0x03,
  0xfc, 0xfc, 0xff, 0xff, 0x33, 0x33, 0x30, 0x30, 0x30, 0x30, 0xf0, 0xf0, 0xc0, 0xc0, 0x00,
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x03, 0x03, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x03, 0x03, 0x00,

  // char '7'
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xff, 0xff, 0x3f, 0x3f, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xff, 0xff, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char '8'
  0xf0, 0xf0, 0xfc, 0xfc, 0x0f, 0x0f, 0x03, 0x03, 0x03, 0x0f, 0x0f, 0xfc, 0xfc, 0xf0, 0xf0,
  0x03, 0x03, 0xcf, 0xcf, 0xfc, 0xfc, 0x30, 0x30, 0x30, 0xfc, 0xfc, 0xcf, 0xcf, 0x03, 0x03,
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x03, 0x03, 0x0f, 0x0f, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x03, 0x03, 0x00, 0x00,

  // char '9'
  0xe0, 0xf0, 0xfc, 0xfc, 0x0f, 0x0f, 0x03, 0x03, 0x03, 0x0f, 0x0f, 0xfc, 0xfc, 0xf0, 0xe0,
  0x07, 0x0f, 0x3f, 0x3f, 0xf0, 0xf0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xfc, 0xfc, 0x3f, 0x3f, 0x03,
  0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x0f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char ':'
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char ';' -> space
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char '<' -> backward
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x30, 0xF0, 0x90, 0x50, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x50, 0x90, 0xF0, 0x30,
  0x00, 0x00, 0x03, 0x0E, 0x39, 0xE7, 0x9F, 0x7F, 0x9F, 0xE7, 0x39, 0x0E, 0x03, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0E, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char '=' -> F
  0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  // char '>' -> forward
  0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0x38, 0xCE, 0x38, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x80, 0xE0, 0x38, 0x4E, 0x73, 0x7C, 0x7F, 0x7F, 0x7F, 0x7C, 0x73, 0x4E, 0x38, 0xE0, 0x80,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  
  // char '?' -> question
  0x80, 0xC0, 0xE0, 0xE0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE0, 0xE0, 0xC0, 0x80, 0x80,
  0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0xF9, 0x7F, 0x3F, 0x0E,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x9C, 0x9F, 0x9F, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

};

#endif
